/* $Id: fwrev.c,v 1.3 1998/07/20 21:12:54 ericb Exp $ */
/* Copyright (C) 1997 - 1998, Hewlett-Packard Company, all rights reserved. */
/* Written by Eric Backus */

/* Return the revision value for a sema.bin file */

#include "sema.h"

/* Search for string as next characters in file fp, skipping null
   characters in file fp.  Return 1 if string found, 0 if not, -1 if
   error.  If string is not found, the first non-matching character is
   pushed back into fp so that subsequent string searches will
   work properly. */
#ifndef	E1485_SOURCE
static int
match(FILE *fp, char *string)
{
    int     c;

    while (*string != '\0')
    {
	c = getc(fp);
	if (c == '\0')		/* Ignore null characters */
	    continue;
	if (c != *string)
	{
	    if (c != EOF && ungetc(c, fp) == EOF)
		return -1;	/* Error */
	    return 0;		/* No match found */
	}
	string++;
    }
    return 1;			/* Match found */
}
#endif

/* Return firmware rev of sema.bin file identified by path.  Returns
   error if file not found or no firmware rev found. */
SHORTSIZ16 EXPORT
e1432_get_fwrev(char *path, LONGSIZ32 *rev)
{
#ifndef	E1485_SOURCE
    LONGSIZ32 fwrev;
    FILE   *fp;
    int     c, i, status;

    fp = fopen(path, "rb");
    if (fp == NULL)
	return i1432_print_error(ERR1432_FILE);

    while ((c = getc(fp)) != EOF)
    {
	if (c == '@')
	{
	    /* Look for what string marker */
	    status = match(fp, "(#)");
	    if (status < 0)
		break;
	    if (status == 0)
		continue;
	    /* Found it, skip 28 more characters, total 32 */
	    for (i = 0; i < 28; i++)
		c = getc(fp);
	    /* Next four are the firmware rev, MSB first */
	    fwrev = getc(fp) << 24;
	    fwrev += getc(fp) << 16;
	    fwrev += getc(fp) << 8;
	    fwrev += getc(fp);
	    /* Abort if we ran into end of file first */
	    if (getc(fp) == EOF)
		break;
	    *rev = fwrev;
	    return 0;
	}
	if (c == '$')
	{
	    /* Look for RCS Date marker */
	    status = match(fp, "Date: ");
	    if (status < 0)
		break;
	    if (status == 0)
		continue;
	    /* Found it, read numbers, ignoring '/' and '\0', and
	       parse into fwrev */
	    fwrev = 0;
	    do
	    {
		c = getc(fp);
		if (isdigit(c))
		    fwrev = fwrev * 10 + c - '0';
	    }
	    while (c == '\0' || c == '/' || isdigit(c));
	    /* Abort if we ran into end of file first */
	    if (getc(fp) == EOF)
		break;
	    *rev = fwrev;
	    return 0;
	}
    }
#endif

    return i1432_print_error(ERR1432_FILE);
}

#if 0
/* For testing this function */
int
main(void)
{
    LONGSIZ32 fwrev;
    SHORTSIZ16 error;

    error = e1432_get_fwrev("/opt/e1432/lib/sema.bin", &fwrev);
    if (error < 0)
	return 1;

    (void) printf("firmware rev %ld\n", fwrev);

    return 0;
}
#endif
